import { Mail } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"

export default function ComingSoon() {
  return (
    <main className="min-h-screen flex flex-col items-center justify-center bg-background px-6 py-12">
      <div className="max-w-2xl w-full text-center space-y-12">
        {/* Logo/Branding */}
        <div className="space-y-2">
          <div className="inline-flex items-center justify-center w-16 h-16 rounded-full bg-accent mb-4">
            <div className="w-8 h-8 rounded-full bg-accent-foreground/20"></div>
          </div>
          <h1 className="text-4xl md:text-5xl font-bold text-balance tracking-tight text-foreground">CAPELANDCARE</h1>
          <p className="text-lg text-muted-foreground leading-relaxed">Compassionate care solutions coming soon</p>
        </div>

        {/* Main Headline */}
        <div className="space-y-4">
          <p className="text-xl md:text-2xl font-light text-pretty text-foreground/80 leading-relaxed">
            We're crafting something extraordinary. A new approach to care that puts you first.
          </p>
          <div className="w-12 h-1 bg-accent mx-auto"></div>
        </div>

        {/* Email Signup */}
        <form className="space-y-4 pt-4">
          <div className="flex flex-col sm:flex-row gap-3">
            <Input
              type="email"
              placeholder="Enter your email"
              className="flex-1 h-12 px-4 border-border bg-background text-foreground placeholder:text-muted-foreground"
              required
            />
            <Button
              type="submit"
              className="h-12 px-8 bg-accent hover:bg-accent/90 text-accent-foreground font-medium transition-colors"
            >
              <Mail className="w-4 h-4 mr-2" />
              Notify Me
            </Button>
          </div>
          <p className="text-sm text-muted-foreground">Be first to know when we launch</p>
        </form>

        {/* Footer Info */}
        <div className="pt-12 border-t border-border">
          <p className="text-sm text-muted-foreground">Coming Q2 2026 • Redefining care for everyone</p>
        </div>
      </div>
    </main>
  )
}
